#CLASES
#------------------------------------------
class World
	attr_gtk
	attr :sprites, :size, :walls, :defaults, :exit, :doors, :switches
	
	def initialize args, level
		@map_id = level
		@parse_map = args.gtk.parse_json_file "levels/test.json"
		@size = { w: @parse_map['levels'][@map_id]['pxWid'],
							h: @parse_map['levels'][@map_id]['pxHei']
		}
		@sprites = load_sprites args
		@walls = load_walls args
		@defaults = load_defaults args
		@exit = get_exit
		@doors = get_doors
		@switches = get_switches
	end	

	def load_sprites args
		new_sprites = Array.new
	  @parse_map['levels'][@map_id]['layerInstances'][2]['gridTiles'].each do |ln|
	    new_sprites << { x: ln['px'][0],
                       y: (@size.h - 16) - ln['px'][1],
                       w: 16,
                       h: 16,
                       path: @parse_map['levels'][@map_id]['layerInstances'][2]['__tilesetRelPath'].delete_prefix('../'),
                       tile_x: ln['src'][0],
                       tile_y: ln['src'][1],
                       tile_w: 16,
                       tile_h: 16}
	  end
	  return new_sprites
	end

	def load_walls args
		new_walls = Array.new
		rows = (@size.h / 16).to_i
    cols = (@size.w / 16).to_i
  	rows.times do |y_new|
	  cols.times do |x_new|
	    new_index = y_new * 16 + x_new
	    if @parse_map['levels'][@map_id]['layerInstances'][0]['intGridCsv'][new_index] == 1
	    new_walls << { x: x_new * 16,
                     y: (@size.h - 16) - (y_new * 16),
                     w: 16,
                     h: 16,
                    id: 'w'}
	    end
	  end
  	end
	  return new_walls
 	end

 	def load_defaults args
 		defaults = Array.new
 		@parse_map['levels'][@map_id]['layerInstances'][1]['entityInstances'].each { |e| defaults << e }
		return defaults
 	end

 	def player_start
 		player_start_pos = @defaults.select {|e| e['__identifier'] == 'Player'}
 		return {x: player_start_pos[0]['px'][0], y: (@size.h - 16) - player_start_pos[0]['px'][1]}
	end

	def enemies_list
		enemies_start_pos = @defaults.select {|e| e['__identifier'] == 'Enemy'}
		enemies_list = Array.new
		enemies_start_pos.each do |e|
			enemies_list << {x: e['px'][0], y: (@size.h - 16) - e['px'][1] }
		end
		return enemies_list
	end

	def get_exit
		exit_pos = @defaults.select {|e| e['__identifier'] == 'Exit'}
		return {x: exit_pos[0]['px'][0], y: (@size.h - 16) - exit_pos[0]['px'][1], w: 16, h:16 }
	end

	def get_doors
	  doors_parse = @defaults.select {|e| e['__identifier'] == 'Door'}
    doors_list = Array.new
    doors_parse.each do |door|
      new_door = { x: door['px'][0], y: (@size.h - 16) - door['px'][1], w: 16, h: 16 }
      doors_list << Door.new(new_door, door['iid'])
    end
    return doors_list
	end

	def get_switches
	  switches_parse = @defaults.select {|e| e['__identifier'] == 'Switch'}
	  switches_list = Array.new
	  switches_parse.each do |switch|
	    new_switch = { x: switch['px'][0], y: (@size.h - 16) - switch['px'][1], w: 16, h: 16 }
	    link = switch['fieldInstances'][0]['__value']['entityIid']
	    switches_list << Switch.new(new_switch, link)
	  end
	  return switches_list
	end

	def exit? args
	return true if @exit.intersect_rect? args.state.player
	end
end

class Enemy
	attr_gtk
	attr_rect
	attr :pos, :x, :y, :w, :h, :is_dead

	def initialize pos
	@x = pos.x
	@y = pos.y
	@w = 16
	@h = 16
	@direction = 'horizontal'
	@new_direction = {x: 16, y: 0}
	@cooldown = 16
	@is_dead = false
	@player_inside = false
	end

	def move args
		if @cooldown <= 0
		motion args
		@cooldown = 16
		end
		@cooldown -= 0.8
 	end

	# def motion args
	# 	case @direction
 #  		when 'horizontal'
 #  		new_position = {x: @moving_x, y: 0}
 #  		@moving_x = @moving_x * -1 if collision? new_position, args
 #  		@x += @moving_x if !collision? new_position, args
 #  		when 'vertical'
 #  		new_position = {x: 0, y: @moving_y}
 #  		@moving_y = @moving_y * -1 if collision? new_position, args
 #  		@y += @moving_y if !collision? new_position, args
 #  		# when 'follow'
 #  		# if args.state.player.y + 16 < @y
 #    #     @moving_x = 0
 #    #     @moving_y = -16
 #  		# elsif args.state.player.y + 16> @y
 #    #     @moving_x = 0
 #    #     @moving_y = 16
 #  		# end
 #  		# new_position = { x: @moving_x, y: @moving_y }
 #  		# @y += @moving_y if !collision? new_position, args
 #  		# @x += @moving_x if !collision? new_position, args
 #  		when 'follow'
 #  		if player_spotted? args
 #  		args.outputs.debug << "hay"
 #  		end
# 	end
	# end

  def motion args
  change_axis args
	case @direction
	when 'horizontal'
	@new_direction.x = @new_direction.x * -1 if collision? @new_direction, args
	when 'vertical'
		@new_direction.y = @new_direction.y * -1 if collision? @new_direction, args
	end
	
  @x += @new_direction.x
  @y += @new_direction.y
  end

  def change_axis args
  if @direction == 'horizontal'
  	@direction = 'vertical'
  	@new_direction.x = 0
  	@new_direction.y = 16
	else
		@direction = 'horizontal'
  	@new_direction.x = 16
  	@new_direction.y = 0
  end
  end

	def player_spotted? args
	#spot_rect = { x: @x - 32, y: @y - 32, w: 80, h: 80 }
	spot_rect = { x: @x - 48, y: @y - 48, w: 112, h: 112 }
	return true if args.state.player.inside_rect? spot_rect
	end

 	def collision? new_position, args
 	new_position = { x: @x + new_position.x,
                   y: @y + new_position.y,
                   h: @h,
                   w: @w
 	    }
  check_doors = args.state.world.doors.select {|door| !door.is_open}
 	return true if args.state.world.walls.any_intersect_rect? new_position or args.state.player.intersect_rect? new_position or args.state.seeds.any_intersect_rect? new_position or check_doors.any_intersect_rect? new_position
 	end

  def check_hit args
  	current = {x: @x, y: @y, w: @w, h: @h}
	  args.state.germinations.each do |germination|
	  	if germination.has_started
		 		if germination.pos.intersect_rect? current
				@is_dead = true
		 		end
	 		end
  	end	
  end
  
end


class Player
	attr_gtk
	attr_rect
	attr :pos, :x, :y, :w, :h, :carry, :plant_cooldown
	def initialize pos
	@x = pos.x
	@y = pos.y
	@w = pos.w
	@h = pos.h
	@carry = false
	@has_planted = false
	@plant_cooldown = 0
	end
	
	def move args
		step = 16
    args.state.mover_timer ||= 0
    if args.state.mover_timer <= 0
      new_position = { x: @x,
                       y: @y,
                       h: @h,
                       w: @w
    }
      moved = false
      if args.inputs.keyboard.key_held.up
        new_position.y += step
        @y += step unless collisions? args, new_position
        moved = true
      end
      if args.inputs.keyboard.key_held.down
        new_position.y -= step
        @y -= step unless collisions? args, new_position 
        moved = true
      end
      if args.inputs.keyboard.key_held.left
        new_position.x -= step
        @x -= step unless collisions? args, new_position
        moved = true
      end
      if args.inputs.keyboard.key_held.right
        new_position.x += step
        @x += step unless collisions? args, new_position
        moved = true 
      end
    end
    args.state.mover_timer = 8 if moved
    args.state.mover_timer -= 0.8
  end

  def collisions? args, new_position
  check_doors = args.state.world.doors.select {|door| !door.is_open}
  return true if args.state.world.walls.any_intersect_rect? new_position or args.state.enemies.any_intersect_rect? new_position or args.state.seeds.any_intersect_rect? new_position or check_doors.any_intersect_rect? new_position
  end

  def action args
  	if @has_planted == false and !collisions?(args, {x: @x, y: @y, h: @h, w: @w})
	    if args.keyboard.key_held.z
	    args.outputs.debug << "z pressed"
	    @carry = true
	    end
	    if args.keyboard.key_up.z
	    @carry = false
	    @has_planted = true
	    @plant_cooldown = 30
	    new_seed = {x: @x, y: @y, w: 16, h:16}
	    args.state.seeds << Seed.new(new_seed, args.state.current_shape.dup)
	    args.state.current_shape = set_shape args
	    end
    end
    if @has_planted == true
    	@plant_cooldown -= 1
    end
    if @plant_cooldown <= 0
			@has_planted = false
    end
  end
end

class Seed
  attr_gtk
  attr_rect
  attr :is_dead, :x, :y, :w, :h
  	
  def initialize pos, shape
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @stored_shape = shape
  @is_dead = false
  @counter = 60
  end

  def germinate args
  @counter -= 1
  args.outputs.debug << "germinando"
		if @counter <= 0
			base_germination = {x: @x, y: @y, w: @w, h: @h}
      if !args.state.world.switches.any_intersect_rect? base_germination
			args.state.germinations << Germination.new(base_germination, 0)
  			@stored_shape.each do |shape|
  				new_shape = {x: @x + shape.x, y: @y + shape.y, w: @w, h: @h}
  				args.state.germinations << Germination.new(new_shape, 10)
  			  end
  		elsif args.state.world.switches.any_intersect_rect? base_germination
  		find_switch = args.state.world.switches.find {|switch| intersect_rect? switch, base_germination}
  		find_switch.use args
  		args.outputs.debug << "#{find_switch.link}"
			end
			@is_dead = true
		end
  end
  
end

class Germination
	attr_gtk
	attr_rect
	attr :pos, :is_dead, :has_started
	
	def initialize pos, pre_count	
	@pos_buffer = pos
	@time_to_appear = pre_count
	@time_when_created = Kernel.tick_count
	@has_started = false
	@pos = nil
	@time_when_started = nil
	@is_dead = false
	end

	def set_up args
		if Kernel.tick_count - @time_when_created >= @time_to_appear and !@has_started
			if !args.state.world.walls.any_intersect_rect? @pos_buffer 
				@pos = @pos_buffer
				@time_when_started = Kernel.tick_count
				@has_started = true
			else
				@is_dead = true
			end
		end
	end

	def banish args
		if @has_started
			if Kernel.tick_count - @time_when_started >= 20
				@is_dead = true
			end
		end
	end
	
end

class Door
  attr_gtk
  attr_rect
  attr :link, :is_open, :x, :y, :w, :h

  def initialize pos, link
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @link = link
  @is_open = false
  end

  def open
  @is_open = true
  end

  def sprite
	  case @is_open
	  when false
	  sprite = { x: @x, 
	             y: @y, 
	             w: @w, 
	             h: @h, 
	             r: 255, 
	             g: 255, 
	             b: 0 }
	  when true
	  return
	  end
  end
  
end

class Switch
  attr_gtk
  attr_rect
  attr :link, :was_used, :x, :y, :w, :h

  def initialize pos, link
  @x = pos.x
  @y = pos.y
  @w = pos.w
  @h = pos.h
  @link = link
  @was_used = false
  end

  def use args
	  door_to_open = args.state.world.doors.find {|door| door.link == @link}
	  door_to_open.open
	  @was_used = true
  end

  def sprite
  	case @was_used
  	when false
    sprite = { x: @x,
               y: @y,
               w: @w,
               h: @h,
               r: 0,
               g: 255,
               b: 255 }
    when true
	  end
  end
  
end

#-----------------------------------------------------------
#FUNCIONES DE AYUDA
def set_shape args
  shape_cross = [ #horizontal y vertical
									{x: 0, y: 16},
									{x: 0, y: -16},
									{x: 16, y: 0},
									{x: -16, y: 0}
  ]
  shape_x = [ #diagonales
									{x: -16, y: -16},
									{x: -16, y: 16},
									{x: 16, y: -16},
									{x: 16, y: 16}
	]
	shape_vertical = [
									{x: 0, y: 16},
									{x: 0, y: -16}
	]
	shape_horizontal = [
									{x: 16, y: 0},
									{x: -16, y: 0}
	]
	shape_t = shape_cross.dup
	shape_t.delete_at(rand(4))
	shape_options = [shape_cross, 
	              shape_x,
	              shape_vertical, 
	              shape_horizontal, 
	              shape_t]
	new_pattern = shape_options.sample
	return new_pattern
end


def render args
  args.outputs.solids << { x: 0, y: 0, w: 1280, h: 720 } #fondo negro
	#graficos del hud
	args.outputs[:hud].sprites << {x: 0, y: 0, w: 5, h: 720, r: 255, g: 255, b: 255}
	args.outputs[:hud].sprites << {x: 15, y: 0, w: 5, h: 720, r: 255, g: 255, b: 255}
	args.outputs[:hud].sprites << {x: 210,
																 y: 210,
																 w: 60,
																 h: 60-args.state.player.plant_cooldown}
	args.state.current_shape.each do |shape|
  args.outputs[:hud].solids << {x: 200 + (shape.x*5), y: 200 + (shape.y*5), w: 80, h: 80,
  															r: 255, g: 255, b: 255}
	end
															  
	#graficos del nivel
	args.state.world.sprites.each { |tile| args.outputs[:scene].sprites << tile }
	args.state.seeds.each do |seed|
		args.outputs[:scene].sprites << { x: seed.x,
																		  y: seed.y,
																		  w: 16,
																		  h: 16,
																		  r: 0, g: 0, b: 255
		}
	end
	args.state.germinations.each do |germination|
		if germination.has_started
			args.outputs[:scene].sprites << { x: germination.pos.x,
																				y: germination.pos.y,
																				w: germination.pos.w,
																				h: germination.pos.h,
																				r: 0, g: 255, b: 0, a: 140
				}
		end
	end
	args.state.enemies.each do |enemy|
		args.outputs[:scene].sprites << { x: enemy.x,
																		  y: enemy.y,
																		  w: 16,
																		  h: 16,
																		  path: 'sprites/ghost.png'
		}
	end
	args.outputs[:scene].sprites << { x: args.state.world.exit.x,
																		y: args.state.world.exit.y,
																		w: args.state.world.exit.w,
																		h: args.state.world.exit.h,
																		r: 255, g: 0, b: 0
	}
	args.state.world.doors.each { |door| args.outputs[:scene].sprites << door.sprite }
  args.state.world.switches.each { |switch| args.outputs[:scene].sprites << switch.sprite }

	if args.state.player.carry
  	args.state.current_shape.each do |shape|
  	  args.outputs[:scene].sprites << {
  	                           x: args.state.player.x + shape.x,
  	                           y: args.state.player.y + shape.y,
  	                           w: 16,
  	                           h: 16,
  	                           r: 255, g: 255, b: 255, a: 60
  	  }
  	end
	end

	args.outputs[:scene].sprites << {
	                           x: args.state.player.x,
	                           y: args.state.player.y,
	                           w: args.state.player.w,
	                           h: args.state.player.h,
	                           path: 'sprites/chara.png'
	  }
	if args.state.player.carry
  	args.outputs[:scene].sprites << {
  	                           x: args.state.player.x+4,
  	                           y: args.state.player.y+5,
  	                           w: 8,
  	                           h: 8,
  	                           r: 0, g: 0, b: 255
  	  }
	end

  args.outputs.sprites << { x: 32,
                            y: draw_camera(args),
                            w: args.grid.w*2.2,
                            h: args.grid.h*2.2,
                            path: :scene
  }
	args.outputs.sprites << { x: 820,
														y: 0,
														w: 1280,
														h: 720,
														path: :hud}
end

def draw_camera args
  args.state.camera.next_y = (args.state.world.size.h/4) - args.state.player.y
  args.state.camera.changing ||= false
  easing ||= 0.2

  if args.state.camera.prev_y != args.state.camera.next_y
    args.state.camera.changing = true
  end

  if args.state.camera.changing == true
  difference = args.state.camera.next_y - args.state.camera.prev_y
  args.state.camera.prev_y += difference * easing
    if difference.abs < easing
    args.state.camera.prev_y = args.state.camera.next_y
    args.state.camera.changing = false
    end
  end
  
  return args.state.camera.prev_y
end

def build_world args
	if !args.state.loaded
  	args.state.world = World.new args, args.state.current_level
  	args.state.player.x = args.state.world.player_start.x
  	args.state.player.y = args.state.world.player_start.y
  	args.state.enemies = Array.new
  	args.state.world.enemies_list.each do |e|
    	new_enemy = {x: e.x, y: e.y, w: 16, h: 16 }
    	args.state.enemies << Enemy.new(new_enemy)
    	end
  	args.state.seeds = Array.new
  	args.state.germinations = Array.new
  	args.state.current_shape = set_shape args
    args.state.camera.prev_y = (args.state.world.size.h/4) - args.state.player.y
  	args.state.loaded = true
	end
end

#LOGICA PRINCIPAL
#--------------------------------------------
def tick args
	args.state.current_level ||= 1
	args.state.loaded ||= false
	args.state.player ||= Player.new({ x: 0, y: 0, w: 16, h: 16 })
	build_world args

	#calcular interacciones
  args.state.player.move args
  args.state.player.action args
  args.state.enemies.each {|e| e.move args}
	args.state.seeds.each {|e| e.germinate args}
	args.state.seeds.reject! {|e| e.is_dead}
	args.state.germinations.each {|e| e.set_up args}
	args.state.enemies.each {|e| e.check_hit args}
	args.state.enemies.reject! {|e| e.is_dead}
	args.state.germinations.each {|e| e.banish args}
	args.state.germinations.reject! {|e| e.is_dead}
	if args.state.world.exit? args
	args.outputs.debug << 'salida tocada'
	args.state.current_level += 1
	args.state.current_level = 0 if args.state.current_level > 1
	args.state.loaded = false
	build_world args
	end
	#render
	render args

	#debug  
  args.outputs.debug << "map size #{args.state.world.size.w}, #{args.state.world.size.h}"
  args.outputs.debug << "player x: #{args.state.player.x} y: #{args.state.player.y}"
	args.outputs.debug << "paredes #{args.state.world.walls.size}"

end

$gtk.reset
